//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
struct st_Base
{
    private:
        uint KeyValue;
    public:
    //+----------------+
        void SetKey(const uint arg) { KeyValue = arg; }
    //+----------------+
        uint GetKey(void) { return KeyValue; }
};
//+------------------------------------------------------------------+
struct st_Reg : public st_Base
{
    private:
        string  Value;
    public:
    //+----------------+
        void SetValue(const uint arg1, const string arg2)
        {
            SetKey(arg1);
            Value = arg2;
        }
    //+----------------+
        string GetValue(void)  { return Value; }
};
//+------------------------------------------------------------------+
struct st_Bio : public st_Base
{
    private:
        string  Value[2];
    public:
    //+----------------+
        void SetValue(const uint arg1, const string arg2, const string arg3)
        {
            SetKey(arg1);
            Value[0] = arg2;
            Value[1] = arg3;
        }
    //+----------------+
        bool GetValue(string &arg1, string &arg2)
        {
            arg1 = Value[0];
            arg2 = Value[1];

            return true;
        }
    //+----------------+
};
//+------------------------------------------------------------------+
template <typename T>
struct st_Data
{
    private:
        T Values[];
    public:
    //+----------------+
        bool Set(const T &arg)
        {
            if (ArrayResize(Values, Values.Size() + (Values.Size() == 0 ? 2 : 1)) == INVALID_HANDLE)
                return false;

            Values[Values.Size() - 1] = arg;

            return true;
        }
    //+----------------+
        T Get(const uint index)
        {
            for (uint c = 0; c < Values.Size(); c++)
                if (Values[c].GetKey() == index)
                    return Values[c];

            return Values[0];
        }
};
//+------------------------------------------------------------------+
#define PrintX(X) Print(#X, " => [", X, "]")
//+------------------------------------------------------------------+
void CheckBio(st_Data <st_Bio> &arg)
{
    string sz[2];

    Print("Checking data in the structure...");
    for (uint i = 7; i < 11; i += 3)
    {
        Print("Index: ", i, " Result: ");
        if (arg.Get(i).GetValue(sz[0], sz[1]))
            ArrayPrint(sz);
        else
            Print("Failed.");
    }
}
//+------------------------------------------------------------------+
void OnStart(void)
{
    const string T = "possible loss of data due to type conversion";
    const string M[] = {"2", "cool", "4", "zero", "mad", "five", "what", "xoxo"};
    const uint   K[] = {2, 1, 4, 0, 7, 5, 3, 6};

    st_Data <st_Reg> Info_1;
    st_Data <st_Bio> Info_2;

    string  H[];

    StringSplit(T, ' ', H);
    for (uint c = 0; c < H.Size(); c++)
    {
        st_Reg  reg;
        st_Bio  bio;

        reg.SetValue(K[c], H[c]);
        bio.SetValue(K[c], M[c], H[c]);

        Info_1.Set(reg);
        Info_2.Set(bio);
    }

    PrintX(Info_1.Get(3).GetValue());
    PrintX(Info_1.Get(13).GetValue());
    CheckBio(Info_2);
}
//+------------------------------------------------------------------+